/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element.listbox;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementSlider;

public class SliderHorizontal
extends ElementSlider {
    public SliderHorizontal(IGuiAccess containerScreen, int x, int y, int width, int height, int maxValue) {
        this(containerScreen, x, y, width, height, maxValue, 0);
    }

    public SliderHorizontal(IGuiAccess containerScreen, int x, int y, int width, int height, int maxValue, int minValue) {
        super(containerScreen, x, y, width, height, maxValue, minValue);
        int dist = maxValue - minValue;
        this.setSliderSize(dist <= 0 ? width : Math.max(width / ++dist, 9), height);
    }

    @Override
    public ElementSlider setLimits(int min, int max) {
        int dist = max - min;
        this.setSliderSize(dist <= 0 ? this.width : Math.max(this.width / ++dist, 9), this.height);
        return super.setLimits(min, max);
    }

    @Override
    public int getSliderX() {
        int dist = this._valueMax - this._valueMin;
        int maxPos = this.width - this._sliderWidth;
        return Math.min(dist == 0 ? 0 : maxPos * (this._value - this._valueMin) / dist, maxPos);
    }

    @Override
    public void dragSlider(int v, int y) {
        v += Math.round((float)this._sliderWidth * ((float)v / (float)this.width) + (float)this._sliderWidth * 0.25f);
        this.setValue(this._valueMin + (this._valueMax - this._valueMin) * v / this.width);
    }
}

